package com.ejie.ab04b.service;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;

import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.CoordinadorObra;

/**
 * Ab0484s00Service generated by UDA, 20-feb-2017 12:41:54.
 * 
 * @author UDA
 */

public interface CoordinadorObraService {

	/**
	 * Inserts a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the coordinador obra
	 */
	CoordinadorObra add(CoordinadorObra ab0484s00);

	/**
	 * Updates a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the coordinador obra
	 */
	CoordinadorObra update(CoordinadorObra ab0484s00);

	/**
	 * Finds a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the coordinador obra
	 */
	CoordinadorObra find(CoordinadorObra ab0484s00);

	/**
	 * Finds a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the list
	 */
	List<CoordinadorObra> findCoordinadorMaxFecAlta(CoordinadorObra ab0484s00);

	/**
	 * Deletes a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 */
	void remove(CoordinadorObra ab0484s00);

	/**
	 * Finds a list of rows in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0484s00>
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<CoordinadorObra> findAll(CoordinadorObra ab0484s00,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0484s00 table using like.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0484s00>
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<CoordinadorObra> findAllLike(CoordinadorObra ab0484s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	void removeMultiple(CoordinadorObra filterAb0484s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0484s00>
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<CoordinadorObra> filter(CoordinadorObra filterAb0484s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  searchAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0484s00>>
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param searchAb0484s00 the search ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<CoordinadorObra>> search(CoordinadorObra filterAb0484s00,
			CoordinadorObra searchAb0484s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	Object reorderSelection(CoordinadorObra filterAb0484s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<JerarquiaDto<Ab0484s00>>
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<JerarquiaDto<CoordinadorObra>> jerarquia(
			CoordinadorObra filterAb0484s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<JerarquiaDto<Ab0484s00>>
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<JerarquiaDto<CoordinadorObra>> jerarquiaChildren(
			CoordinadorObra filterAb0484s00, JQGridRequestDto jqGridRequestDto);

	/**
	 * Modificar historico.
	 * 
	 *  coordinadorobraOLD the coordinadorobra OLD
	 *  coordinadorobraNew the coordinadorobra new
	 *  apertura the apertura
	 *
	 * @param coordinadorobraOLD the coordinadorobra OLD
	 * @param coordinadorobraNew the coordinadorobra new
	 * @param apertura the apertura
	 */
	void modificarHistorico(CoordinadorObra coordinadorobraOLD,
			CoordinadorObra coordinadorobraNew, ComunicacionApertura apertura);

	/**
	 * Devuelve el numero de Coordinadores de obra.
	 * 
	 *  coordinador
	 *            CoordinadorObra
	 *  Long
	 *
	 * @param coordinador the coordinador
	 * @return the long
	 */
	long contarCoordeinadoresObra(CoordinadorObra coordinador);

	/**
	 * Devuelve el numero de Coordinadores de Proyecto.
	 * 
	 *  coordinador
	 *            CoordinadorObra
	 *  Long
	 *
	 * @param coordinador the coordinador
	 * @return the long
	 */
	long contarCoordeinadoresProyecto(CoordinadorObra coordinador);

}
